function  [Loss, e] = loss(real, forecast, edges, loss_type)

% Calculates Ranked Probability Score (RPS) loss or Quadratic Probability
% Score (QPS) loss

% INPUT
% real:         vector of realised 
% forecast:     matrix of forecasts
% edges:        matrix of bins edges
% loss_type     1 for RPS (default)
%               2 for QPS

% OUTPUT
% Loss:         Matrix of loss scores (T x H)
% e:            Forecast errors

if nargin<4
    loss_type = 2;
end

binary = NaN([size(forecast,1), size(edges,2)-1, 2]);
Loss = NaN(size(forecast,1),1);

for h = 1:size(real,2)

    for i = 1:size(edges,1)

        if loss_type ==1 % RPS
            temp = histcounts(real(i,h), edges(i,~isnan(edges(i, :))), 'Normalization', 'cdf');
            forecast(i,:,h) = cumsum(forecast(i,:,h),2);

        elseif loss_type ==2 % QPS
            temp = histcounts(real(i,h), edges(i,~isnan(edges(i, :))), 'Normalization', 'probability');
        end

        binary(i,1:length(temp),h) = temp(1:length(edges(i,~isnan(edges(i, :))))-1);
    end

    e(:,:,h) = binary(:,:,h)- forecast(:,:,h);
    Loss(:,h) = nansum(e(:,:,h).^2,2);

end
end